standardFont = "fonts/franklingothic_demicond.mvec";
--uiFont = "fonts/garamondpremierpro.mvec";

BlackColor = Color(0,0,0,255);
GrayColor = Color(100,100,100,255);
BlueColor = Color(77,115,178,255);
DarkBlueColor = Color(40,60,120,255);
WhiteColor = Color(255,255,255,255);
RedColor = Color(255,0,0,255);
MenuButtonFontColor = Color(255,255,255,255);

StandardButtonGraphics = {
	"buttons/buttonup",
	"buttons/buttondown",
	"buttons/buttonrollover"
};

AdventureButtonGraphics = {
	"buttons/button_playadventure_up",
	"buttons/button_playadventure_down",
	"buttons/button_playadventure_over"
};

ActivityButtonGraphics = {
	"buttons/button_playactivities_up",
	"buttons/button_playactivities_down",
	"buttons/button_playactivities_over"
};

ActivityButtonUnlockGraphics = {
	"buttons/button_playactivities_unlock",
	"buttons/button_playactivities_down",
	"buttons/button_playactivities_over"
};

ChangePlayerButtonGraphics = {
	"buttons/button_changeplayer_up",
	"buttons/button_changeplayer_down",
	"buttons/button_changeplayer_over"
};

ThinButtonGraphics = 
{
	"buttons/button_thin_up",
	"buttons/button_thin_down",
	"buttons/button_thin_over"
};

LongBlueButtonGraphics = 
{
	"buttons/button_long_blue_up",
	"buttons/button_long_blue_down",
	"buttons/button_long_blue_over"
};

CheckboxButtonGraphics = {
	"buttons/checkup",
	"buttons/checkdown",
	"buttons/checkover",
	"buttons/checkdownover"
};

BackButtonGraphics = {
	"buttons/button_back_up",
	"buttons/button_back_down",
	"buttons/button_back_over",
}

StandardButtonFont = {
  standardFont,
  17,
  BlackColor
};

ThinButtonFont = {
  standardFont,
  14,
  BlackColor
};

SmallButtonFont = {
  standardFont,
  12,
  BlackColor
};

EnterNameFont = {
  standardFont,
  19,
  WhiteColor,
}

MenuButtonFont = {
  standardFont,
  22,
  MenuButtonFontColor,
  
};

DialogTitleFont = {
  standardFont,
  22,
  BlackColor
};

DialogBodyFont = {
  standardFont,
  18,
  BlackColor
};

WelcomeFont = {
  standardFont,
  18,
  BlackColor
};

PopupFont = {
  standardFont,
  18,
  BlackColor
--  WhiteColor,
--  outline_size = 2,
--  outline_color = BlackColor,
};

BackButtonFont = {
  standardFont,
  15,
  WhiteColor
};

CheckBoxButtonButtonFont = {
  standardFont,
  14,
  BlackColor
};

DefaultStyle = {
	font=DialogBodyFont
};

DialogTitleText = {
	parent = DefaultStyle,
	font = DialogTitleFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=16,y=12,w=kMax,h=120,
};

DialogBodyText = {
	parent=DefaultStyle,
	font = DialogBodyFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=0,y=46,w=kMax,h=kMax-60
};

SliderStyle =
{
	parent=DefaultStyle,
	railtop = "slider/sliderrailtop",
	railmid = "slider/sliderrailmid",
	railbot = "slider/sliderrailbot",
	sliderimage = "slider/sliderknob",
	sliderrollimage = "slider/sliderknobover",

	yoffset = -1, -- scoot the slider down by one pixel to center it.
};

kDefaultButtonSound="audio/sfx/buttonclick.ogg";
kDefaultButtonRollOverSound="audio/sfx/button_rollover.ogg";

MenuButtonStyle = {
	parent = DefaultStyle,
	font = MenuButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonRollOverSound,
	graphics = {},
	w=169, h=40
};

ButtonStyle = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonRollOverSound,
	label = "",
	type= kPush,
	graphics = StandardButtonGraphics,
};

AdventureButtonStyle = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonRollOverSound,
	type= kPush,
	graphics = AdventureButtonGraphics
};

ActivityButtonStyle = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonRollOverSound,
	type= kPush,
	graphics = ActivityButtonGraphics
};

ActivityButtonUnlockStyle = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonRollOverSound,
	type= kPush,
	graphics = ActivityButtonUnlockGraphics
};

ChangePlayerButtonStyle = {
	parent = DefaultStyle,
	font = SmallButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonRollOverSound,
	type= kPush,
	graphics = ChangePlayerButtonGraphics
};

ThinButtonStyle = {
	parent = ButtonStyle,
	font = ThinButtonFont,
	graphics = ThinButtonGraphics
};

LongBlueButtonStyle = {
	parent = ButtonStyle,
	font = ThinButtonFont,
	graphics = LongBlueButtonGraphics,
};

BackButtonStyle = {
	parent = ButtonStyle,
	graphics = BackButtonGraphics,
};

CheckboxButtonStyle = {
	parent = DefaultStyle,
	font = CheckBoxButtonButtonFont,
	type = kToggle,
	flags = kHAlignLeft + kVAlignCenter,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonRollOverSound,
	graphics = CheckboxButtonGraphics,
};

SetDefaultStyle(DefaultStyle);

-- Create a TButton with a label
--
-- We're overriding the default "Button" here with
-- some custom behavior. Specifically, we're layering
-- a Text{} object on top of every button, and it's placed
-- on all layers (up, down, roll-over).
function Button( button )
	return function()
		-- Grab the label from the button or current style
		if (GetTag(button,"label")) then

			-- Look for text dimensions
			local tx = GetTag(button,"tx");
			local ty = GetTag(button,"ty");
			local tw = GetTag(button,"tw");
			local th = GetTag(button,"th");

			-- Set defaults
			if (not tx) then
				tx = 0;
			end
			if (not ty) then
				ty = 0;
			end
			if (not tw) then
				tw=kMax ;
			end
			if (not th) then
				th=kMax ;
			end

			if GetTag(button, "graphics") then
				--table.insert(button, ButtonGraphicsMask(button["graphics_mask"]));
				local graphics = GetTag(button, "graphics");
				table.insert(button, 
					Group
					{
						SelectLayer(0);
						Bitmap
						{
							image = graphics[1],
							mask = exists(tostring(graphics[1]) .. ".mask.png"),
						},
						SelectLayer(1),
						Bitmap
						{
							image = graphics[2],
							mask = exists(tostring(graphics[2]) .. ".mask.png"),
						},
						SelectLayer(2),
						Bitmap
						{
							image = graphics[3],
							mask = exists(tostring(graphics[3]) .. ".mask.png"),
						},
						SelectLayer(3),
						Bitmap
						{
							image = graphics[4],
							mask = exists(tostring(graphics[4]) .. ".mask.png"),
						},
					}
				);
			end
			
			button.graphics = {};
			
			-- Get the label
			local label = GetTag(button,"label");

			local defflags = kPushButtonAlignment ;
			if (GetTag(button,"type")==kToggle) then
				defflags = kToggleButtonAlignment ;
			elseif (GetTag(button,"type")==kRadio) then
				defflags = kRadioButtonAlignment ;
			end

			local textfactory = GetTag(button,"textfactory");
			if (not textfactory) then
				textfactory = "_text"
			end
			table.insert(button,
				SelectLayer( kAllLayers )
			);
			-- Grow our window to encompass any children we've added
			-- already.
			table.insert(button,
				FitToChildren()
			);

			table.insert(button,
				AppendStyle{ font=button.font; flags=button.flags; }
			);

			table.insert(button,
				Text
				{
					label=label,
					x=tx, y=ty, w=tw, h=th,
					name='label',
					defflags =defflags
				}
			)
		end

		-- Type name of window to create; in our case, "Button".
		-- If you want to create a derived button type, you can do that here.
		button.typename='tDFButton';
		DoWindow( button )
	end
end

-- Create several bits of text that combine to make a blended shadow
function ColorShadowText( x,y,size, label, color )

	return Group(
		{
		-- Add these traits to the current style
			AppendStyle{ x=x, y=y, w=kMax, h=kMax, label=label },
			AppendStyle{ font = { standardFont, size, Color(0,0,0,40)} },
			Text{ y=y+4 },
			AppendStyle{ font = { standardFont, size, Color(0,0,0,255)} },
			Text{ y=y+2 },
			AppendStyle{ font = { standardFont, size, color } } ,
			Text{},
		}
	)
end

kMenuButtonFontSize = 22;

function MenuButtonLabel( label, color, colorHighlight )

	if not color then
		color =Color(192,207,255,255);	-- the default colors
		colorHighlight=Color(255,255,255,255)
	end

	return Group{
		Bitmap
		{
			image = "backgrounds/bar",
			x=0,y=0,scale=1
		},
		SelectLayer(0),
		ColorShadowText(5,8,kMenuButtonFontSize, label, color ),
		SelectLayer(1),
		ColorShadowText(5,8,kMenuButtonFontSize, label, colorHighlight ),
		SelectLayer(2),
		ColorShadowText(5,8,kMenuButtonFontSize, label, colorHighlight )
	}

end

-- Create a more limited-use button type here; the label is defined inline
-- with MenuButtonLabel above
function MenuButton( button )
	return function()
		-- Type name of window to create; in our case, "Button".
		-- If you want to create a derived button type, you can do that here.
		button.typename='tDFButton';
		DoWindow( button )
	end
end

kIllegalNameChars = "!@#$%^&*()><\\\"\'[]{}|?/+=~`.,;:-";

function StartClose()
	local kGeneric = 0;
	DebugOut("StartClose()");
	PostMessage ( CreateNamedMessage( kGeneric, "startclose" ) );
end

function QuickClose()
	local kGeneric = 0;
	DebugOut("QuickClose()");
	PostMessage ( CreateNamedMessage( kGeneric, "quickclose" ) );
end

slide_speed_in = 50;
slide_accel_in = 5;
slide_speed_out = 50;
slide_accel_out = 5;

-- speed_in = slide_speed_in, speed_out = slide_speed_out, accel_in = slice_accel_in, accel_out = slide_accel_out,

function dfDisplayDialog(table)
	gDialogTable = 
	{ 
		body = table.body,
		title = table.title,
		yes = function()
			ModalReturn("yes");
			StartClose();
		end;
		no = function()
			ModalReturn("no");
			StartClose();
		end;
	};
	return DoModal(table[1]);
end;

-- Create a TButton with a label
--
-- We're overriding the default "Button" here with
-- some custom behavior. Specifically, we're layering
-- a Text{} object on top of every button, and it's placed
-- on all layers (up, down, roll-over).
function tRegButton( button )
	return function()
		-- Grab the label from the button or current style
		if (GetTag(button,"label")) then

			-- Look for text dimensions
			local tx = GetTag(button,"tx");
			local ty = GetTag(button,"ty");
			local tw = GetTag(button,"tw");
			local th = GetTag(button,"th");

			-- Set defaults
			if (not tx) then
				tx = 0;
			end
			if (not ty) then
				ty = 0;
			end
			if (not tw) then
				tw=kMax ;
			end
			if (not th) then
				th=kMax ;
			end

			-- Get the label
			local label = GetTag(button,"label");

			local box_flags = GetTag(button, "box_flags");
			
			local defflags = kPushButtonAlignment ;
			if (GetTag(button,"type")==kToggle) then
				defflags = kToggleButtonAlignment ;
			elseif (GetTag(button,"type")==kRadio) then
				defflags = kRadioButtonAlignment ;
			end

			local textfactory = GetTag(button,"textfactory");
			if (not textfactory) then
				textfactory = "_text"
			end
			table.insert(button, SelectLayer( kAllLayers ) );
			-- Grow our window to encompass any children we've added
			-- already.
			table.insert(button, FitToChildren());

			table.insert(button,AppendStyle{ font=button.font; flags=button.flags; });

			table.insert(button,
				dfText
				{
					label=label,
					x=tx, y=ty, w=tw, h=th,
					name='label',
					defflags =defflags,
					box_flags = box_flags,
				}
			)
		else
			table.insert(button, SelectLayer( kAllLayers ) );
			
			-- Grow our window to encompass any children we've added already.
			table.insert(button, FitToChildren() );

			table.insert(button, AppendStyle{ font=button.font; flags=button.flags; });
		end

		-- Type name of window to create; in our case, "Button".
		-- If you want to create a derived button type, you can do that here.
		button.typename='tRegButton';
		DoWindow( button )
	end
end

function exists(filename)
	if FileExists(filename) then
		return filename;
	else
		return nil;
	end
end
